package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportApiRequest(
    apiId: __string,
    exportVersion: Option[__string] = None,
    includeExtensions: Option[__boolean] = None,
    outputType: __string,
    specification: __string,
    stageName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest = {
    import ExportApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .optionallyWith(
        exportVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.exportVersion)
      .optionallyWith(
        includeExtensions.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeExtensions)
      .outputType(__string.unwrap(outputType): java.lang.String)
      .specification(__string.unwrap(specification): java.lang.String)
      .optionallyWith(
        stageName.map(value => __string.unwrap(value): java.lang.String)
      )(_.stageName)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.ExportApiRequest.ReadOnly =
    zio.aws.apigatewayv2.model.ExportApiRequest.wrap(buildAwsValue())
}
object ExportApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.ExportApiRequest =
      zio.aws.apigatewayv2.model.ExportApiRequest(
        apiId,
        exportVersion.map(value => value),
        includeExtensions.map(value => value),
        outputType,
        specification,
        stageName.map(value => value)
      )
    def apiId: __string
    def exportVersion: Option[__string]
    def includeExtensions: Option[__boolean]
    def outputType: __string
    def specification: __string
    def stageName: Option[__string]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getExportVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("exportVersion", exportVersion)
    def getIncludeExtensions: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("includeExtensions", includeExtensions)
    def getOutputType: ZIO[Any, Nothing, __string] = ZIO.succeed(outputType)
    def getSpecification: ZIO[Any, Nothing, __string] =
      ZIO.succeed(specification)
    def getStageName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stageName", stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest
  ) extends zio.aws.apigatewayv2.model.ExportApiRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val exportVersion: Option[__string] = scala
      .Option(impl.exportVersion())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val includeExtensions: Option[__boolean] = scala
      .Option(impl.includeExtensions())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val outputType: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.outputType())
    override val specification: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.specification())
    override val stageName: Option[__string] = scala
      .Option(impl.stageName())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ExportApiRequest
  ): zio.aws.apigatewayv2.model.ExportApiRequest.ReadOnly = new Wrapper(impl)
}
