package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait LoggingLevel {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel
}
object LoggingLevel {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel
  ): zio.aws.apigatewayv2.model.LoggingLevel = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel =
      software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ERROR extends zio.aws.apigatewayv2.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel =
      software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.ERROR
  }
  case object INFO extends zio.aws.apigatewayv2.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel =
      software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.INFO
  }
  case object OFF extends zio.aws.apigatewayv2.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel =
      software.amazon.awssdk.services.apigatewayv2.model.LoggingLevel.OFF
  }
}
