package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetVpcLinksResponse(
    items: Option[Iterable[zio.aws.apigatewayv2.model.VpcLink]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse = {
    import GetVpcLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetVpcLinksResponse.wrap(buildAwsValue())
}
object GetVpcLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetVpcLinksResponse =
      zio.aws.apigatewayv2.model.GetVpcLinksResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.apigatewayv2.model.VpcLink.ReadOnly]]
    def nextToken: Option[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.VpcLink.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse
  ) extends zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly {
    override val items
        : Option[List[zio.aws.apigatewayv2.model.VpcLink.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.VpcLink.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apigatewayv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksResponse
  ): zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly = new Wrapper(impl)
}
