package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  StringWithLengthBetween0And1024,
  __timestampIso8601,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetDeploymentResponse(
    autoDeployed: Option[__boolean] = None,
    createdDate: Option[__timestampIso8601] = None,
    deploymentId: Option[Id] = None,
    deploymentStatus: Option[zio.aws.apigatewayv2.model.DeploymentStatus] =
      None,
    deploymentStatusMessage: Option[__string] = None,
    description: Option[StringWithLengthBetween0And1024] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse = {
    import GetDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse
      .builder()
      .optionallyWith(
        autoDeployed.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.autoDeployed)
      .optionallyWith(
        createdDate.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        deploymentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetDeploymentResponse.wrap(buildAwsValue())
}
object GetDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetDeploymentResponse =
      zio.aws.apigatewayv2.model.GetDeploymentResponse(
        autoDeployed.map(value => value),
        createdDate.map(value => value),
        deploymentId.map(value => value),
        deploymentStatus.map(value => value),
        deploymentStatusMessage.map(value => value),
        description.map(value => value)
      )
    def autoDeployed: Option[__boolean]
    def createdDate: Option[__timestampIso8601]
    def deploymentId: Option[Id]
    def deploymentStatus: Option[zio.aws.apigatewayv2.model.DeploymentStatus]
    def deploymentStatusMessage: Option[__string]
    def description: Option[StringWithLengthBetween0And1024]
    def getAutoDeployed: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("autoDeployed", autoDeployed)
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDeploymentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.DeploymentStatus] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse
  ) extends zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly {
    override val autoDeployed: Option[__boolean] = scala
      .Option(impl.autoDeployed())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val createdDate: Option[__timestampIso8601] = scala
      .Option(impl.createdDate())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.__timestampIso8601(value)
      )
    override val deploymentId: Option[Id] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val deploymentStatus
        : Option[zio.aws.apigatewayv2.model.DeploymentStatus] = scala
      .Option(impl.deploymentStatus())
      .map(value => zio.aws.apigatewayv2.model.DeploymentStatus.wrap(value))
    override val deploymentStatusMessage: Option[__string] = scala
      .Option(impl.deploymentStatusMessage())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentResponse
  ): zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
