package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDeploymentRequest(apiId: __string, deploymentId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest = {
    import GetDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .deploymentId(__string.unwrap(deploymentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetDeploymentRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetDeploymentRequest.wrap(buildAwsValue())
}
object GetDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetDeploymentRequest =
      zio.aws.apigatewayv2.model.GetDeploymentRequest(apiId, deploymentId)
    def apiId: __string
    def deploymentId: __string
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getDeploymentId: ZIO[Any, Nothing, __string] = ZIO.succeed(deploymentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest
  ) extends zio.aws.apigatewayv2.model.GetDeploymentRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val deploymentId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.deploymentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentRequest
  ): zio.aws.apigatewayv2.model.GetDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
