package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetIntegrationResponsesRequest(
    apiId: __string,
    integrationId: __string,
    maxResults: Option[__string] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest = {
    import GetIntegrationResponsesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .integrationId(__string.unwrap(integrationId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => __string.unwrap(value): java.lang.String)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest
      .wrap(buildAwsValue())
}
object GetIntegrationResponsesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest =
      zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest(
        apiId,
        integrationId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def apiId: __string
    def integrationId: __string
    def maxResults: Option[__string]
    def nextToken: Option[__string]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getIntegrationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(integrationId)
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest
  ) extends zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val integrationId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.integrationId())
    override val maxResults: Option[__string] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponsesRequest
  ): zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest.ReadOnly =
    new Wrapper(impl)
}
