package zio.aws.apigatewaymanagementapi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.apigatewaymanagementapi.model.primitives.__timestampIso8601
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetConnectionResponse(
    connectedAt: Optional[__timestampIso8601] = Optional.Absent,
    identity: Optional[zio.aws.apigatewaymanagementapi.model.Identity] =
      Optional.Absent,
    lastActiveAt: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse = {
    import GetConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
      .builder()
      .optionallyWith(connectedAt.map(value => value: Instant))(_.connectedAt)
      .optionallyWith(identity.map(value => value.buildAwsValue()))(_.identity)
      .optionallyWith(lastActiveAt.map(value => value: Instant))(_.lastActiveAt)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly =
    zio.aws.apigatewaymanagementapi.model.GetConnectionResponse
      .wrap(buildAwsValue())
}
object GetConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigatewaymanagementapi.model.GetConnectionResponse =
      zio.aws.apigatewaymanagementapi.model.GetConnectionResponse(
        connectedAt.map(value => value),
        identity.map(value => value.asEditable),
        lastActiveAt.map(value => value)
      )
    def connectedAt: Optional[__timestampIso8601]
    def identity
        : Optional[zio.aws.apigatewaymanagementapi.model.Identity.ReadOnly]
    def lastActiveAt: Optional[__timestampIso8601]
    def getConnectedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("connectedAt", connectedAt)
    def getIdentity: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewaymanagementapi.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("identity", identity)
    def getLastActiveAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastActiveAt", lastActiveAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
  ) extends zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly {
    override val connectedAt: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectedAt())
        .map(value => value: __timestampIso8601)
    override val identity
        : Optional[zio.aws.apigatewaymanagementapi.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identity())
        .map(value =>
          zio.aws.apigatewaymanagementapi.model.Identity.wrap(value)
        )
    override val lastActiveAt: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastActiveAt())
        .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
  ): zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
