package zio.aws.apigatewaymanagementapi
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.apigatewaymanagementapi.model.{
  PostToConnectionRequest,
  GetConnectionRequest,
  DeleteConnectionRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly
object ApiGatewayManagementApiMock extends Mock[ApiGatewayManagementApi] {
  object DeleteConnection
      extends Effect[DeleteConnectionRequest, AwsError, Unit]
  object GetConnection extends Effect[GetConnectionRequest, AwsError, ReadOnly]
  object PostToConnection
      extends Effect[PostToConnectionRequest, AwsError, Unit]
  val compose: URLayer[Proxy, ApiGatewayManagementApi] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ApiGatewayManagementApi {
          val api: ApiGatewayManagementApiAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ApiGatewayManagementApi = this
          def deleteConnection(
              request: DeleteConnectionRequest
          ): IO[AwsError, Unit] = proxy(DeleteConnection, request)
          def getConnection(
              request: GetConnectionRequest
          ): IO[AwsError, ReadOnly] = proxy(GetConnection, request)
          def postToConnection(
              request: PostToConnectionRequest
          ): IO[AwsError, Unit] = proxy(PostToConnection, request)
        }
      }
    }
  }
}
