package zio.aws.apigatewaymanagementapi
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.apigatewaymanagementapi.{
  ApiGatewayManagementApiAsyncClientBuilder,
  ApiGatewayManagementApiAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.apigatewaymanagementapi.model.{
  PostToConnectionRequest,
  GetConnectionRequest,
  DeleteConnectionRequest
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.apigatewaymanagementapi.model.{
  DeleteConnectionResponse,
  PostToConnectionResponse,
  GetConnectionResponse
}
import zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly
import scala.jdk.CollectionConverters._
trait ApiGatewayManagementApi extends AspectSupport[ApiGatewayManagementApi] {
  val api: ApiGatewayManagementApiAsyncClient
  def deleteConnection(request: DeleteConnectionRequest): IO[AwsError, Unit]
  def getConnection(request: GetConnectionRequest): IO[AwsError, ReadOnly]
  def postToConnection(request: PostToConnectionRequest): IO[AwsError, Unit]
}
object ApiGatewayManagementApi {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ApiGatewayManagementApi] =
    customized(identity)
  def customized(
      customization: ApiGatewayManagementApiAsyncClientBuilder => ApiGatewayManagementApiAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ApiGatewayManagementApi] = managed(
    customization
  ).toLayer
  def managed(
      customization: ApiGatewayManagementApiAsyncClientBuilder => ApiGatewayManagementApiAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ApiGatewayManagementApi] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ApiGatewayManagementApiAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ApiGatewayManagementApiAsyncClient,
        ApiGatewayManagementApiAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ApiGatewayManagementApiAsyncClient,
        ApiGatewayManagementApiAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ApiGatewayManagementApiImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ApiGatewayManagementApiImpl[R](
      override val api: ApiGatewayManagementApiAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ApiGatewayManagementApi
      with AwsServiceBase[R] {
    override val serviceName: String = "ApiGatewayManagementApi"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ApiGatewayManagementApiImpl[R1] =
      new ApiGatewayManagementApiImpl(api, newAspect, r)
    def deleteConnection(request: DeleteConnectionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionRequest,
        DeleteConnectionResponse
      ]("deleteConnection", api.deleteConnection)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getConnection(request: GetConnectionRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionRequest,
        GetConnectionResponse
      ]("getConnection", api.getConnection)(request.buildAwsValue())
        .map(zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.wrap)
        .provideEnvironment(r)
    def postToConnection(request: PostToConnectionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest,
        PostToConnectionResponse
      ]("postToConnection", api.postToConnection)(request.buildAwsValue()).unit
        .provideEnvironment(r)
  }
  def deleteConnection(request: DeleteConnectionRequest): ZIO[
    zio.aws.apigatewaymanagementapi.ApiGatewayManagementApi,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def getConnection(request: GetConnectionRequest): ZIO[
    zio.aws.apigatewaymanagementapi.ApiGatewayManagementApi,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnection(request))
  def postToConnection(request: PostToConnectionRequest): ZIO[
    zio.aws.apigatewaymanagementapi.ApiGatewayManagementApi,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.postToConnection(request))
}
