package zio.aws.apigatewaymanagementapi.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.apigatewaymanagementapi.model.primitives.{__string, Data}
import scala.jdk.CollectionConverters._
final case class PostToConnectionRequest(data: Data, connectionId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest = {
    import PostToConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest
      .builder()
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .connectionId(__string.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewaymanagementapi.model.PostToConnectionRequest.ReadOnly =
    zio.aws.apigatewaymanagementapi.model.PostToConnectionRequest
      .wrap(buildAwsValue())
}
object PostToConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigatewaymanagementapi.model.PostToConnectionRequest =
      zio.aws.apigatewaymanagementapi.model
        .PostToConnectionRequest(data, connectionId)
    def data: Data
    def connectionId: __string
    def getData: ZIO[Any, Nothing, Data] = ZIO.succeed(data)
    def getConnectionId: ZIO[Any, Nothing, __string] = ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest
  ) extends zio.aws.apigatewaymanagementapi.model.PostToConnectionRequest.ReadOnly {
    override val data: Data = zio.aws.apigatewaymanagementapi.model.primitives
      .Data(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
    override val connectionId: __string =
      zio.aws.apigatewaymanagementapi.model.primitives
        .__string(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest
  ): zio.aws.apigatewaymanagementapi.model.PostToConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
