package zio.aws.apigatewaymanagementapi.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewaymanagementapi.model.primitives.__timestampIso8601
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetConnectionResponse(
    connectedAt: Option[__timestampIso8601] = None,
    identity: Option[zio.aws.apigatewaymanagementapi.model.Identity] = None,
    lastActiveAt: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse = {
    import GetConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
      .builder()
      .optionallyWith(
        connectedAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.connectedAt)
      .optionallyWith(identity.map(value => value.buildAwsValue()))(_.identity)
      .optionallyWith(
        lastActiveAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.lastActiveAt)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly =
    zio.aws.apigatewaymanagementapi.model.GetConnectionResponse
      .wrap(buildAwsValue())
}
object GetConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigatewaymanagementapi.model.GetConnectionResponse =
      zio.aws.apigatewaymanagementapi.model.GetConnectionResponse(
        connectedAt.map(value => value),
        identity.map(value => value.asEditable),
        lastActiveAt.map(value => value)
      )
    def connectedAt: Option[__timestampIso8601]
    def identity
        : Option[zio.aws.apigatewaymanagementapi.model.Identity.ReadOnly]
    def lastActiveAt: Option[__timestampIso8601]
    def getConnectedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("connectedAt", connectedAt)
    def getIdentity: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewaymanagementapi.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("identity", identity)
    def getLastActiveAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastActiveAt", lastActiveAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
  ) extends zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly {
    override val connectedAt: Option[__timestampIso8601] = scala
      .Option(impl.connectedAt())
      .map(value =>
        zio.aws.apigatewaymanagementapi.model.primitives
          .__timestampIso8601(value)
      )
    override val identity
        : Option[zio.aws.apigatewaymanagementapi.model.Identity.ReadOnly] =
      scala
        .Option(impl.identity())
        .map(value =>
          zio.aws.apigatewaymanagementapi.model.Identity.wrap(value)
        )
    override val lastActiveAt: Option[__timestampIso8601] = scala
      .Option(impl.lastActiveAt())
      .map(value =>
        zio.aws.apigatewaymanagementapi.model.primitives
          .__timestampIso8601(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewaymanagementapi.model.GetConnectionResponse
  ): zio.aws.apigatewaymanagementapi.model.GetConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
