package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MutualTlsAuthenticationInput(
    truststoreUri: Optional[String] = Optional.Absent,
    truststoreVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.MutualTlsAuthenticationInput = {
    import MutualTlsAuthenticationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.MutualTlsAuthenticationInput
      .builder()
      .optionallyWith(truststoreUri.map(value => value: java.lang.String))(
        _.truststoreUri
      )
      .optionallyWith(truststoreVersion.map(value => value: java.lang.String))(
        _.truststoreVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly =
    zio.aws.apigateway.model.MutualTlsAuthenticationInput.wrap(buildAwsValue())
}
object MutualTlsAuthenticationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.MutualTlsAuthenticationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.MutualTlsAuthenticationInput =
      zio.aws.apigateway.model.MutualTlsAuthenticationInput(
        truststoreUri.map(value => value),
        truststoreVersion.map(value => value)
      )
    def truststoreUri: Optional[String]
    def truststoreVersion: Optional[String]
    def getTruststoreUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("truststoreUri", truststoreUri)
    def getTruststoreVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("truststoreVersion", truststoreVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.MutualTlsAuthenticationInput
  ) extends zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly {
    override val truststoreUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.truststoreUri())
      .map(value => value: String)
    override val truststoreVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.truststoreVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.MutualTlsAuthenticationInput
  ): zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly =
    new Wrapper(impl)
}
