package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetUsageRequest(
    usagePlanId: String,
    keyId: Optional[String] = Optional.Absent,
    startDate: String,
    endDate: String,
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsageRequest = {
    import GetUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsageRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .optionallyWith(keyId.map(value => value: java.lang.String))(_.keyId)
      .startDate(startDate: java.lang.String)
      .endDate(endDate: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsageRequest.ReadOnly =
    zio.aws.apigateway.model.GetUsageRequest.wrap(buildAwsValue())
}
object GetUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsageRequest =
      zio.aws.apigateway.model.GetUsageRequest(
        usagePlanId,
        keyId.map(value => value),
        startDate,
        endDate,
        position.map(value => value),
        limit.map(value => value)
      )
    def usagePlanId: String
    def keyId: Optional[String]
    def startDate: String
    def endDate: String
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getStartDate: ZIO[Any, Nothing, String] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, String] = ZIO.succeed(endDate)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsageRequest
  ) extends zio.aws.apigateway.model.GetUsageRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val keyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => value: String)
    override val startDate: String = impl.startDate(): String
    override val endDate: String = impl.endDate(): String
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsageRequest
  ): zio.aws.apigateway.model.GetUsageRequest.ReadOnly = new Wrapper(impl)
}
