package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUsagePlansResponse(
    position: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.apigateway.model.UsagePlan]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse = {
    import GetUsagePlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlansResponse.wrap(buildAwsValue())
}
object GetUsagePlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlansResponse =
      zio.aws.apigateway.model.GetUsagePlansResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Optional[String]
    def items: Optional[List[zio.aws.apigateway.model.UsagePlan.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.UsagePlan.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse
  ) extends zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.apigateway.model.UsagePlan.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.UsagePlan.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse
  ): zio.aws.apigateway.model.GetUsagePlansResponse.ReadOnly = new Wrapper(impl)
}
