package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.{NullableBoolean, NullableInteger}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetApiKeysRequest(
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent,
    nameQuery: Optional[String] = Optional.Absent,
    customerId: Optional[String] = Optional.Absent,
    includeValues: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest = {
    import GetApiKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .optionallyWith(nameQuery.map(value => value: java.lang.String))(
        _.nameQuery
      )
      .optionallyWith(customerId.map(value => value: java.lang.String))(
        _.customerId
      )
      .optionallyWith(includeValues.map(value => value: java.lang.Boolean))(
        _.includeValues
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetApiKeysRequest.ReadOnly =
    zio.aws.apigateway.model.GetApiKeysRequest.wrap(buildAwsValue())
}
object GetApiKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetApiKeysRequest =
      zio.aws.apigateway.model.GetApiKeysRequest(
        position.map(value => value),
        limit.map(value => value),
        nameQuery.map(value => value),
        customerId.map(value => value),
        includeValues.map(value => value)
      )
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def nameQuery: Optional[String]
    def customerId: Optional[String]
    def includeValues: Optional[NullableBoolean]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNameQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nameQuery", nameQuery)
    def getCustomerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerId", customerId)
    def getIncludeValues: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeValues", includeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest
  ) extends zio.aws.apigateway.model.GetApiKeysRequest.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
    override val nameQuery: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nameQuery())
      .map(value => value: String)
    override val customerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerId())
      .map(value => value: String)
    override val includeValues: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeValues())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest
  ): zio.aws.apigateway.model.GetApiKeysRequest.ReadOnly = new Wrapper(impl)
}
