package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccountResponse(
    cloudwatchRoleArn: Optional[String] = Optional.Absent,
    throttleSettings: Optional[zio.aws.apigateway.model.ThrottleSettings] =
      Optional.Absent,
    features: Optional[Iterable[String]] = Optional.Absent,
    apiKeyVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetAccountResponse = {
    import GetAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetAccountResponse
      .builder()
      .optionallyWith(cloudwatchRoleArn.map(value => value: java.lang.String))(
        _.cloudwatchRoleArn
      )
      .optionallyWith(throttleSettings.map(value => value.buildAwsValue()))(
        _.throttleSettings
      )
      .optionallyWith(
        features.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.features)
      .optionallyWith(apiKeyVersion.map(value => value: java.lang.String))(
        _.apiKeyVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetAccountResponse.ReadOnly =
    zio.aws.apigateway.model.GetAccountResponse.wrap(buildAwsValue())
}
object GetAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetAccountResponse =
      zio.aws.apigateway.model.GetAccountResponse(
        cloudwatchRoleArn.map(value => value),
        throttleSettings.map(value => value.asEditable),
        features.map(value => value),
        apiKeyVersion.map(value => value)
      )
    def cloudwatchRoleArn: Optional[String]
    def throttleSettings
        : Optional[zio.aws.apigateway.model.ThrottleSettings.ReadOnly]
    def features: Optional[List[String]]
    def apiKeyVersion: Optional[String]
    def getCloudwatchRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudwatchRoleArn", cloudwatchRoleArn)
    def getThrottleSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.ThrottleSettings.ReadOnly
    ] = AwsError.unwrapOptionField("throttleSettings", throttleSettings)
    def getFeatures: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("features", features)
    def getApiKeyVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("apiKeyVersion", apiKeyVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetAccountResponse
  ) extends zio.aws.apigateway.model.GetAccountResponse.ReadOnly {
    override val cloudwatchRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudwatchRoleArn())
      .map(value => value: String)
    override val throttleSettings
        : Optional[zio.aws.apigateway.model.ThrottleSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throttleSettings())
        .map(value => zio.aws.apigateway.model.ThrottleSettings.wrap(value))
    override val features: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.features())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val apiKeyVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKeyVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetAccountResponse
  ): zio.aws.apigateway.model.GetAccountResponse.ReadOnly = new Wrapper(impl)
}
