package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetDomainNameResponse(
    domainName: Optional[String] = Optional.Absent,
    certificateName: Optional[String] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    certificateUploadDate: Optional[Timestamp] = Optional.Absent,
    regionalDomainName: Optional[String] = Optional.Absent,
    regionalHostedZoneId: Optional[String] = Optional.Absent,
    regionalCertificateName: Optional[String] = Optional.Absent,
    regionalCertificateArn: Optional[String] = Optional.Absent,
    distributionDomainName: Optional[String] = Optional.Absent,
    distributionHostedZoneId: Optional[String] = Optional.Absent,
    endpointConfiguration: Optional[
      zio.aws.apigateway.model.EndpointConfiguration
    ] = Optional.Absent,
    domainNameStatus: Optional[zio.aws.apigateway.model.DomainNameStatus] =
      Optional.Absent,
    domainNameStatusMessage: Optional[String] = Optional.Absent,
    securityPolicy: Optional[zio.aws.apigateway.model.SecurityPolicy] =
      Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    mutualTlsAuthentication: Optional[
      zio.aws.apigateway.model.MutualTlsAuthentication
    ] = Optional.Absent,
    ownershipVerificationCertificateArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse = {
    import GetDomainNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
      .builder()
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(
        certificateUploadDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.certificateUploadDate)
      .optionallyWith(regionalDomainName.map(value => value: java.lang.String))(
        _.regionalDomainName
      )
      .optionallyWith(
        regionalHostedZoneId.map(value => value: java.lang.String)
      )(_.regionalHostedZoneId)
      .optionallyWith(
        regionalCertificateName.map(value => value: java.lang.String)
      )(_.regionalCertificateName)
      .optionallyWith(
        regionalCertificateArn.map(value => value: java.lang.String)
      )(_.regionalCertificateArn)
      .optionallyWith(
        distributionDomainName.map(value => value: java.lang.String)
      )(_.distributionDomainName)
      .optionallyWith(
        distributionHostedZoneId.map(value => value: java.lang.String)
      )(_.distributionHostedZoneId)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(domainNameStatus.map(value => value.unwrap))(
        _.domainNameStatus
      )
      .optionallyWith(
        domainNameStatusMessage.map(value => value: java.lang.String)
      )(_.domainNameStatusMessage)
      .optionallyWith(securityPolicy.map(value => value.unwrap))(
        _.securityPolicy
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        ownershipVerificationCertificateArn.map(value =>
          value: java.lang.String
        )
      )(_.ownershipVerificationCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly =
    zio.aws.apigateway.model.GetDomainNameResponse.wrap(buildAwsValue())
}
object GetDomainNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDomainNameResponse =
      zio.aws.apigateway.model.GetDomainNameResponse(
        domainName.map(value => value),
        certificateName.map(value => value),
        certificateArn.map(value => value),
        certificateUploadDate.map(value => value),
        regionalDomainName.map(value => value),
        regionalHostedZoneId.map(value => value),
        regionalCertificateName.map(value => value),
        regionalCertificateArn.map(value => value),
        distributionDomainName.map(value => value),
        distributionHostedZoneId.map(value => value),
        endpointConfiguration.map(value => value.asEditable),
        domainNameStatus.map(value => value),
        domainNameStatusMessage.map(value => value),
        securityPolicy.map(value => value),
        tags.map(value => value),
        mutualTlsAuthentication.map(value => value.asEditable),
        ownershipVerificationCertificateArn.map(value => value)
      )
    def domainName: Optional[String]
    def certificateName: Optional[String]
    def certificateArn: Optional[String]
    def certificateUploadDate: Optional[Timestamp]
    def regionalDomainName: Optional[String]
    def regionalHostedZoneId: Optional[String]
    def regionalCertificateName: Optional[String]
    def regionalCertificateArn: Optional[String]
    def distributionDomainName: Optional[String]
    def distributionHostedZoneId: Optional[String]
    def endpointConfiguration
        : Optional[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly]
    def domainNameStatus: Optional[zio.aws.apigateway.model.DomainNameStatus]
    def domainNameStatusMessage: Optional[String]
    def securityPolicy: Optional[zio.aws.apigateway.model.SecurityPolicy]
    def tags: Optional[Map[String, String]]
    def mutualTlsAuthentication
        : Optional[zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly]
    def ownershipVerificationCertificateArn: Optional[String]
    def getDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getCertificateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateUploadDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("certificateUploadDate", certificateUploadDate)
    def getRegionalDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionalDomainName", regionalDomainName)
    def getRegionalHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionalHostedZoneId", regionalHostedZoneId)
    def getRegionalCertificateName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateName", regionalCertificateName)
    def getRegionalCertificateArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateArn", regionalCertificateArn)
    def getDistributionDomainName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("distributionDomainName", distributionDomainName)
    def getDistributionHostedZoneId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("distributionHostedZoneId", distributionHostedZoneId)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.EndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getDomainNameStatus
        : ZIO[Any, AwsError, zio.aws.apigateway.model.DomainNameStatus] =
      AwsError.unwrapOptionField("domainNameStatus", domainNameStatus)
    def getDomainNameStatusMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("domainNameStatusMessage", domainNameStatusMessage)
    def getSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.apigateway.model.SecurityPolicy] =
      AwsError.unwrapOptionField("securityPolicy", securityPolicy)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getOwnershipVerificationCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ownershipVerificationCertificateArn",
        ownershipVerificationCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
  ) extends zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly {
    override val domainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => value: String)
    override val certificateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateName())
      .map(value => value: String)
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val certificateUploadDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateUploadDate())
        .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val regionalDomainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.regionalDomainName())
      .map(value => value: String)
    override val regionalHostedZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.regionalHostedZoneId())
      .map(value => value: String)
    override val regionalCertificateName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionalCertificateName())
        .map(value => value: String)
    override val regionalCertificateArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionalCertificateArn())
        .map(value => value: String)
    override val distributionDomainName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionDomainName())
        .map(value => value: String)
    override val distributionHostedZoneId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionHostedZoneId())
        .map(value => value: String)
    override val endpointConfiguration
        : Optional[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointConfiguration())
        .map(value =>
          zio.aws.apigateway.model.EndpointConfiguration.wrap(value)
        )
    override val domainNameStatus
        : Optional[zio.aws.apigateway.model.DomainNameStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNameStatus())
        .map(value => zio.aws.apigateway.model.DomainNameStatus.wrap(value))
    override val domainNameStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNameStatusMessage())
        .map(value => value: String)
    override val securityPolicy
        : Optional[zio.aws.apigateway.model.SecurityPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicy())
        .map(value => zio.aws.apigateway.model.SecurityPolicy.wrap(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val mutualTlsAuthentication
        : Optional[zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mutualTlsAuthentication())
        .map(value =>
          zio.aws.apigateway.model.MutualTlsAuthentication.wrap(value)
        )
    override val ownershipVerificationCertificateArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownershipVerificationCertificateArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
  ): zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly = new Wrapper(impl)
}
