package zio.aws.apigateway.model
import scala.jdk.CollectionConverters._
sealed trait QuotaPeriodType {
  def unwrap: software.amazon.awssdk.services.apigateway.model.QuotaPeriodType
}
object QuotaPeriodType {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.QuotaPeriodType
  ): zio.aws.apigateway.model.QuotaPeriodType = value match {
    case software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.DAY =>
      val r = DAY
      r
    case software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.WEEK =>
      val r = WEEK
      r
    case software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.MONTH =>
      val r = MONTH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.QuotaPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.QuotaPeriodType =
      software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.UNKNOWN_TO_SDK_VERSION
  }
  case object DAY extends zio.aws.apigateway.model.QuotaPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.QuotaPeriodType =
      software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.DAY
  }
  case object WEEK extends zio.aws.apigateway.model.QuotaPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.QuotaPeriodType =
      software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.WEEK
  }
  case object MONTH extends zio.aws.apigateway.model.QuotaPeriodType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.QuotaPeriodType =
      software.amazon.awssdk.services.apigateway.model.QuotaPeriodType.MONTH
  }
}
