package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetUsagePlanKeysRequest(
    usagePlanId: String,
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent,
    nameQuery: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest = {
    import GetUsagePlanKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .optionallyWith(nameQuery.map(value => value: java.lang.String))(
        _.nameQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlanKeysRequest.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlanKeysRequest.wrap(buildAwsValue())
}
object GetUsagePlanKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlanKeysRequest =
      zio.aws.apigateway.model.GetUsagePlanKeysRequest(
        usagePlanId,
        position.map(value => value),
        limit.map(value => value),
        nameQuery.map(value => value)
      )
    def usagePlanId: String
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def nameQuery: Optional[String]
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNameQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nameQuery", nameQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
  ) extends zio.aws.apigateway.model.GetUsagePlanKeysRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
    override val nameQuery: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nameQuery())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
  ): zio.aws.apigateway.model.GetUsagePlanKeysRequest.ReadOnly = new Wrapper(
    impl
  )
}
