package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateDocumentationPartRequest(
    restApiId: String,
    location: zio.aws.apigateway.model.DocumentationPartLocation,
    properties: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest = {
    import CreateDocumentationPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .location(location.buildAwsValue())
      .properties(properties: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.CreateDocumentationPartRequest.ReadOnly =
    zio.aws.apigateway.model.CreateDocumentationPartRequest
      .wrap(buildAwsValue())
}
object CreateDocumentationPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateDocumentationPartRequest =
      zio.aws.apigateway.model.CreateDocumentationPartRequest(
        restApiId,
        location.asEditable,
        properties
      )
    def restApiId: String
    def location: zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly
    def properties: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getLocation: ZIO[
      Any,
      Nothing,
      zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly
    ] = ZIO.succeed(location)
    def getProperties: ZIO[Any, Nothing, String] = ZIO.succeed(properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest
  ) extends zio.aws.apigateway.model.CreateDocumentationPartRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val location
        : zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly =
      zio.aws.apigateway.model.DocumentationPartLocation.wrap(impl.location())
    override val properties: String = impl.properties(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest
  ): zio.aws.apigateway.model.CreateDocumentationPartRequest.ReadOnly =
    new Wrapper(impl)
}
