package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class MethodSetting(
    metricsEnabled: Optional[Boolean] = Optional.Absent,
    loggingLevel: Optional[String] = Optional.Absent,
    dataTraceEnabled: Optional[Boolean] = Optional.Absent,
    throttlingBurstLimit: Optional[Integer] = Optional.Absent,
    throttlingRateLimit: Optional[Double] = Optional.Absent,
    cachingEnabled: Optional[Boolean] = Optional.Absent,
    cacheTtlInSeconds: Optional[Integer] = Optional.Absent,
    cacheDataEncrypted: Optional[Boolean] = Optional.Absent,
    requireAuthorizationForCacheControl: Optional[Boolean] = Optional.Absent,
    unauthorizedCacheControlHeaderStrategy: Optional[
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.MethodSetting = {
    import MethodSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.MethodSetting
      .builder()
      .optionallyWith(metricsEnabled.map(value => value: java.lang.Boolean))(
        _.metricsEnabled
      )
      .optionallyWith(loggingLevel.map(value => value: java.lang.String))(
        _.loggingLevel
      )
      .optionallyWith(dataTraceEnabled.map(value => value: java.lang.Boolean))(
        _.dataTraceEnabled
      )
      .optionallyWith(
        throttlingBurstLimit.map(value => value: java.lang.Integer)
      )(_.throttlingBurstLimit)
      .optionallyWith(
        throttlingRateLimit.map(value => value: java.lang.Double)
      )(_.throttlingRateLimit)
      .optionallyWith(cachingEnabled.map(value => value: java.lang.Boolean))(
        _.cachingEnabled
      )
      .optionallyWith(cacheTtlInSeconds.map(value => value: java.lang.Integer))(
        _.cacheTtlInSeconds
      )
      .optionallyWith(
        cacheDataEncrypted.map(value => value: java.lang.Boolean)
      )(_.cacheDataEncrypted)
      .optionallyWith(
        requireAuthorizationForCacheControl.map(value =>
          value: java.lang.Boolean
        )
      )(_.requireAuthorizationForCacheControl)
      .optionallyWith(
        unauthorizedCacheControlHeaderStrategy.map(value => value.unwrap)
      )(_.unauthorizedCacheControlHeaderStrategy)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.MethodSetting.ReadOnly =
    zio.aws.apigateway.model.MethodSetting.wrap(buildAwsValue())
}
object MethodSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.MethodSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.MethodSetting =
      zio.aws.apigateway.model.MethodSetting(
        metricsEnabled.map(value => value),
        loggingLevel.map(value => value),
        dataTraceEnabled.map(value => value),
        throttlingBurstLimit.map(value => value),
        throttlingRateLimit.map(value => value),
        cachingEnabled.map(value => value),
        cacheTtlInSeconds.map(value => value),
        cacheDataEncrypted.map(value => value),
        requireAuthorizationForCacheControl.map(value => value),
        unauthorizedCacheControlHeaderStrategy.map(value => value)
      )
    def metricsEnabled: Optional[Boolean]
    def loggingLevel: Optional[String]
    def dataTraceEnabled: Optional[Boolean]
    def throttlingBurstLimit: Optional[Integer]
    def throttlingRateLimit: Optional[Double]
    def cachingEnabled: Optional[Boolean]
    def cacheTtlInSeconds: Optional[Integer]
    def cacheDataEncrypted: Optional[Boolean]
    def requireAuthorizationForCacheControl: Optional[Boolean]
    def unauthorizedCacheControlHeaderStrategy: Optional[
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ]
    def getMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("metricsEnabled", metricsEnabled)
    def getLoggingLevel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("loggingLevel", loggingLevel)
    def getDataTraceEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataTraceEnabled", dataTraceEnabled)
    def getThrottlingBurstLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throttlingBurstLimit", throttlingBurstLimit)
    def getThrottlingRateLimit: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("throttlingRateLimit", throttlingRateLimit)
    def getCachingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cachingEnabled", cachingEnabled)
    def getCacheTtlInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cacheTtlInSeconds", cacheTtlInSeconds)
    def getCacheDataEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheDataEncrypted", cacheDataEncrypted)
    def getRequireAuthorizationForCacheControl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "requireAuthorizationForCacheControl",
        requireAuthorizationForCacheControl
      )
    def getUnauthorizedCacheControlHeaderStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ] = AwsError.unwrapOptionField(
      "unauthorizedCacheControlHeaderStrategy",
      unauthorizedCacheControlHeaderStrategy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSetting
  ) extends zio.aws.apigateway.model.MethodSetting.ReadOnly {
    override val metricsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.metricsEnabled())
      .map(value => value: Boolean)
    override val loggingLevel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingLevel())
      .map(value => value: String)
    override val dataTraceEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dataTraceEnabled())
      .map(value => value: Boolean)
    override val throttlingBurstLimit: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.throttlingBurstLimit())
      .map(value => value: Integer)
    override val throttlingRateLimit: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.throttlingRateLimit())
      .map(value => value: Double)
    override val cachingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cachingEnabled())
      .map(value => value: Boolean)
    override val cacheTtlInSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheTtlInSeconds())
      .map(value => value: Integer)
    override val cacheDataEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheDataEncrypted())
      .map(value => value: Boolean)
    override val requireAuthorizationForCacheControl: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requireAuthorizationForCacheControl())
        .map(value => value: Boolean)
    override val unauthorizedCacheControlHeaderStrategy: Optional[
      zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unauthorizedCacheControlHeaderStrategy())
      .map(value =>
        zio.aws.apigateway.model.UnauthorizedCacheControlHeaderStrategy
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSetting
  ): zio.aws.apigateway.model.MethodSetting.ReadOnly = new Wrapper(impl)
}
