package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGatewayResponsesResponse(
    position: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.apigateway.model.GatewayResponse]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse = {
    import GetGatewayResponsesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly =
    zio.aws.apigateway.model.GetGatewayResponsesResponse.wrap(buildAwsValue())
}
object GetGatewayResponsesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetGatewayResponsesResponse =
      zio.aws.apigateway.model.GetGatewayResponsesResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Optional[String]
    def items: Optional[List[zio.aws.apigateway.model.GatewayResponse.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.GatewayResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse
  ) extends zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.apigateway.model.GatewayResponse.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.GatewayResponse.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse
  ): zio.aws.apigateway.model.GetGatewayResponsesResponse.ReadOnly =
    new Wrapper(impl)
}
