package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters._
final case class PutGatewayResponseResponse(
    responseType: Optional[zio.aws.apigateway.model.GatewayResponseType] =
      Optional.Absent,
    statusCode: Optional[StatusCode] = Optional.Absent,
    responseParameters: Optional[Map[String, String]] = Optional.Absent,
    responseTemplates: Optional[Map[String, String]] = Optional.Absent,
    defaultResponse: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse = {
    import PutGatewayResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse
      .builder()
      .optionallyWith(responseType.map(value => value.unwrap))(_.responseType)
      .optionallyWith(
        statusCode.map(value => StatusCode.unwrap(value): java.lang.String)
      )(_.statusCode)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(defaultResponse.map(value => value: java.lang.Boolean))(
        _.defaultResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly =
    zio.aws.apigateway.model.PutGatewayResponseResponse.wrap(buildAwsValue())
}
object PutGatewayResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutGatewayResponseResponse =
      zio.aws.apigateway.model.PutGatewayResponseResponse(
        responseType.map(value => value),
        statusCode.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        defaultResponse.map(value => value)
      )
    def responseType: Optional[zio.aws.apigateway.model.GatewayResponseType]
    def statusCode: Optional[StatusCode]
    def responseParameters: Optional[Map[String, String]]
    def responseTemplates: Optional[Map[String, String]]
    def defaultResponse: Optional[Boolean]
    def getResponseType
        : ZIO[Any, AwsError, zio.aws.apigateway.model.GatewayResponseType] =
      AwsError.unwrapOptionField("responseType", responseType)
    def getStatusCode: ZIO[Any, AwsError, StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getResponseParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getDefaultResponse: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultResponse", defaultResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse
  ) extends zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly {
    override val responseType
        : Optional[zio.aws.apigateway.model.GatewayResponseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseType())
        .map(value => zio.aws.apigateway.model.GatewayResponseType.wrap(value))
    override val statusCode: Optional[StatusCode] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => zio.aws.apigateway.model.primitives.StatusCode(value))
    override val responseParameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val responseTemplates: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseTemplates())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val defaultResponse: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultResponse())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse
  ): zio.aws.apigateway.model.PutGatewayResponseResponse.ReadOnly = new Wrapper(
    impl
  )
}
