package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGatewayResponseRequest(
    restApiId: String,
    responseType: zio.aws.apigateway.model.GatewayResponseType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest = {
    import GetGatewayResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .responseType(responseType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetGatewayResponseRequest.ReadOnly =
    zio.aws.apigateway.model.GetGatewayResponseRequest.wrap(buildAwsValue())
}
object GetGatewayResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetGatewayResponseRequest =
      zio.aws.apigateway.model
        .GetGatewayResponseRequest(restApiId, responseType)
    def restApiId: String
    def responseType: zio.aws.apigateway.model.GatewayResponseType
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResponseType
        : ZIO[Any, Nothing, zio.aws.apigateway.model.GatewayResponseType] =
      ZIO.succeed(responseType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest
  ) extends zio.aws.apigateway.model.GetGatewayResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val responseType: zio.aws.apigateway.model.GatewayResponseType =
      zio.aws.apigateway.model.GatewayResponseType.wrap(impl.responseType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest
  ): zio.aws.apigateway.model.GetGatewayResponseRequest.ReadOnly = new Wrapper(
    impl
  )
}
