package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateStageResponse(
    deploymentId: Optional[String] = Optional.Absent,
    clientCertificateId: Optional[String] = Optional.Absent,
    stageName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    cacheClusterEnabled: Optional[Boolean] = Optional.Absent,
    cacheClusterSize: Optional[String] = Optional.Absent,
    cacheClusterStatus: Optional[zio.aws.apigateway.model.CacheClusterStatus] =
      Optional.Absent,
    methodSettings: Optional[
      Map[String, zio.aws.apigateway.model.MethodSetting]
    ] = Optional.Absent,
    variables: Optional[Map[String, String]] = Optional.Absent,
    documentationVersion: Optional[String] = Optional.Absent,
    accessLogSettings: Optional[zio.aws.apigateway.model.AccessLogSettings] =
      Optional.Absent,
    canarySettings: Optional[zio.aws.apigateway.model.CanarySettings] =
      Optional.Absent,
    tracingEnabled: Optional[Boolean] = Optional.Absent,
    webAclArn: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    createdDate: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateStageResponse = {
    import UpdateStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateStageResponse
      .builder()
      .optionallyWith(deploymentId.map(value => value: java.lang.String))(
        _.deploymentId
      )
      .optionallyWith(
        clientCertificateId.map(value => value: java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(stageName.map(value => value: java.lang.String))(
        _.stageName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        cacheClusterEnabled.map(value => value: java.lang.Boolean)
      )(_.cacheClusterEnabled)
      .optionallyWith(cacheClusterSize.map(value => value: java.lang.String))(
        _.cacheClusterSize
      )
      .optionallyWith(cacheClusterStatus.map(value => value.unwrap))(
        _.cacheClusterStatus
      )
      .optionallyWith(
        methodSettings.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.methodSettings)
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(
        documentationVersion.map(value => value: java.lang.String)
      )(_.documentationVersion)
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(canarySettings.map(value => value.buildAwsValue()))(
        _.canarySettings
      )
      .optionallyWith(tracingEnabled.map(value => value: java.lang.Boolean))(
        _.tracingEnabled
      )
      .optionallyWith(webAclArn.map(value => value: java.lang.String))(
        _.webAclArn
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        lastUpdatedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateStageResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateStageResponse.wrap(buildAwsValue())
}
object UpdateStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateStageResponse =
      zio.aws.apigateway.model.UpdateStageResponse(
        deploymentId.map(value => value),
        clientCertificateId.map(value => value),
        stageName.map(value => value),
        description.map(value => value),
        cacheClusterEnabled.map(value => value),
        cacheClusterSize.map(value => value),
        cacheClusterStatus.map(value => value),
        methodSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        variables.map(value => value),
        documentationVersion.map(value => value),
        accessLogSettings.map(value => value.asEditable),
        canarySettings.map(value => value.asEditable),
        tracingEnabled.map(value => value),
        webAclArn.map(value => value),
        tags.map(value => value),
        createdDate.map(value => value),
        lastUpdatedDate.map(value => value)
      )
    def deploymentId: Optional[String]
    def clientCertificateId: Optional[String]
    def stageName: Optional[String]
    def description: Optional[String]
    def cacheClusterEnabled: Optional[Boolean]
    def cacheClusterSize: Optional[String]
    def cacheClusterStatus
        : Optional[zio.aws.apigateway.model.CacheClusterStatus]
    def methodSettings
        : Optional[Map[String, zio.aws.apigateway.model.MethodSetting.ReadOnly]]
    def variables: Optional[Map[String, String]]
    def documentationVersion: Optional[String]
    def accessLogSettings
        : Optional[zio.aws.apigateway.model.AccessLogSettings.ReadOnly]
    def canarySettings
        : Optional[zio.aws.apigateway.model.CanarySettings.ReadOnly]
    def tracingEnabled: Optional[Boolean]
    def webAclArn: Optional[String]
    def tags: Optional[Map[String, String]]
    def createdDate: Optional[Timestamp]
    def lastUpdatedDate: Optional[Timestamp]
    def getDeploymentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getClientCertificateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getStageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCacheClusterEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheClusterEnabled", cacheClusterEnabled)
    def getCacheClusterSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterSize", cacheClusterSize)
    def getCacheClusterStatus
        : ZIO[Any, AwsError, zio.aws.apigateway.model.CacheClusterStatus] =
      AwsError.unwrapOptionField("cacheClusterStatus", cacheClusterStatus)
    def getMethodSettings: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.MethodSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("methodSettings", methodSettings)
    def getVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("variables", variables)
    def getDocumentationVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("documentationVersion", documentationVersion)
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.AccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getCanarySettings
        : ZIO[Any, AwsError, zio.aws.apigateway.model.CanarySettings.ReadOnly] =
      AwsError.unwrapOptionField("canarySettings", canarySettings)
    def getTracingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("tracingEnabled", tracingEnabled)
    def getWebAclArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webAclArn", webAclArn)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateStageResponse
  ) extends zio.aws.apigateway.model.UpdateStageResponse.ReadOnly {
    override val deploymentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => value: String)
    override val clientCertificateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientCertificateId())
      .map(value => value: String)
    override val stageName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val cacheClusterEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterEnabled())
      .map(value => value: Boolean)
    override val cacheClusterSize: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterSize())
      .map(value => value: String)
    override val cacheClusterStatus
        : Optional[zio.aws.apigateway.model.CacheClusterStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheClusterStatus())
        .map(value => zio.aws.apigateway.model.CacheClusterStatus.wrap(value))
    override val methodSettings: Optional[
      Map[String, zio.aws.apigateway.model.MethodSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.methodSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.apigateway.model.MethodSetting.wrap(value)
          })
          .toMap
      )
    override val variables: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val documentationVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.documentationVersion())
      .map(value => value: String)
    override val accessLogSettings
        : Optional[zio.aws.apigateway.model.AccessLogSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLogSettings())
        .map(value => zio.aws.apigateway.model.AccessLogSettings.wrap(value))
    override val canarySettings
        : Optional[zio.aws.apigateway.model.CanarySettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canarySettings())
        .map(value => zio.aws.apigateway.model.CanarySettings.wrap(value))
    override val tracingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.tracingEnabled())
      .map(value => value: Boolean)
    override val webAclArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.webAclArn())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val createdDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val lastUpdatedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateStageResponse
  ): zio.aws.apigateway.model.UpdateStageResponse.ReadOnly = new Wrapper(impl)
}
