package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRestApiRequest(restApiId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest = {
    import DeleteRestApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteRestApiRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteRestApiRequest.wrap(buildAwsValue())
}
object DeleteRestApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteRestApiRequest =
      zio.aws.apigateway.model.DeleteRestApiRequest(restApiId)
    def restApiId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest
  ) extends zio.aws.apigateway.model.DeleteRestApiRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest
  ): zio.aws.apigateway.model.DeleteRestApiRequest.ReadOnly = new Wrapper(impl)
}
