package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAuthorizerRequest(
    restApiId: String,
    authorizerId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest = {
    import DeleteAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .authorizerId(authorizerId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteAuthorizerRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteAuthorizerRequest.wrap(buildAwsValue())
}
object DeleteAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteAuthorizerRequest =
      zio.aws.apigateway.model.DeleteAuthorizerRequest(restApiId, authorizerId)
    def restApiId: String
    def authorizerId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getAuthorizerId: ZIO[Any, Nothing, String] = ZIO.succeed(authorizerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest
  ) extends zio.aws.apigateway.model.DeleteAuthorizerRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val authorizerId: String = impl.authorizerId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest
  ): zio.aws.apigateway.model.DeleteAuthorizerRequest.ReadOnly = new Wrapper(
    impl
  )
}
