package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteResourceRequest(restApiId: String, resourceId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest = {
    import DeleteResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteResourceRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteResourceRequest.wrap(buildAwsValue())
}
object DeleteResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteResourceRequest =
      zio.aws.apigateway.model.DeleteResourceRequest(restApiId, resourceId)
    def restApiId: String
    def resourceId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest
  ) extends zio.aws.apigateway.model.DeleteResourceRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest
  ): zio.aws.apigateway.model.DeleteResourceRequest.ReadOnly = new Wrapper(impl)
}
