package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelRequest(
    restApiId: String,
    name: String,
    description: Optional[String] = Optional.Absent,
    schema: Optional[String] = Optional.Absent,
    contentType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateModelRequest = {
    import CreateModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateModelRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(schema.map(value => value: java.lang.String))(_.schema)
      .contentType(contentType: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateModelRequest.ReadOnly =
    zio.aws.apigateway.model.CreateModelRequest.wrap(buildAwsValue())
}
object CreateModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateModelRequest =
      zio.aws.apigateway.model.CreateModelRequest(
        restApiId,
        name,
        description.map(value => value),
        schema.map(value => value),
        contentType
      )
    def restApiId: String
    def name: String
    def description: Optional[String]
    def schema: Optional[String]
    def contentType: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schema", schema)
    def getContentType: ZIO[Any, Nothing, String] = ZIO.succeed(contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateModelRequest
  ) extends zio.aws.apigateway.model.CreateModelRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val name: String = impl.name(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val schema: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => value: String)
    override val contentType: String = impl.contentType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateModelRequest
  ): zio.aws.apigateway.model.CreateModelRequest.ReadOnly = new Wrapper(impl)
}
