package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStageRequest(restApiId: String, stageName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteStageRequest = {
    import DeleteStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteStageRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteStageRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteStageRequest.wrap(buildAwsValue())
}
object DeleteStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteStageRequest =
      zio.aws.apigateway.model.DeleteStageRequest(restApiId, stageName)
    def restApiId: String
    def stageName: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteStageRequest
  ) extends zio.aws.apigateway.model.DeleteStageRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteStageRequest
  ): zio.aws.apigateway.model.DeleteStageRequest.ReadOnly = new Wrapper(impl)
}
