package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMethodRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest = {
    import DeleteMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteMethodRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteMethodRequest.wrap(buildAwsValue())
}
object DeleteMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteMethodRequest =
      zio.aws.apigateway.model
        .DeleteMethodRequest(restApiId, resourceId, httpMethod)
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest
  ) extends zio.aws.apigateway.model.DeleteMethodRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest
  ): zio.aws.apigateway.model.DeleteMethodRequest.ReadOnly = new Wrapper(impl)
}
