package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MutualTlsAuthentication(
    truststoreUri: Optional[String] = Optional.Absent,
    truststoreVersion: Optional[String] = Optional.Absent,
    truststoreWarnings: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication = {
    import MutualTlsAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
      .builder()
      .optionallyWith(truststoreUri.map(value => value: java.lang.String))(
        _.truststoreUri
      )
      .optionallyWith(truststoreVersion.map(value => value: java.lang.String))(
        _.truststoreVersion
      )
      .optionallyWith(
        truststoreWarnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.truststoreWarnings)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly =
    zio.aws.apigateway.model.MutualTlsAuthentication.wrap(buildAwsValue())
}
object MutualTlsAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.MutualTlsAuthentication =
      zio.aws.apigateway.model.MutualTlsAuthentication(
        truststoreUri.map(value => value),
        truststoreVersion.map(value => value),
        truststoreWarnings.map(value => value)
      )
    def truststoreUri: Optional[String]
    def truststoreVersion: Optional[String]
    def truststoreWarnings: Optional[List[String]]
    def getTruststoreUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("truststoreUri", truststoreUri)
    def getTruststoreVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("truststoreVersion", truststoreVersion)
    def getTruststoreWarnings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("truststoreWarnings", truststoreWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
  ) extends zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly {
    override val truststoreUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.truststoreUri())
      .map(value => value: String)
    override val truststoreVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.truststoreVersion())
      .map(value => value: String)
    override val truststoreWarnings: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truststoreWarnings())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
  ): zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly = new Wrapper(
    impl
  )
}
