package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GenerateClientCertificateResponse(
    clientCertificateId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    pemEncodedCertificate: Optional[String] = Optional.Absent,
    createdDate: Optional[Timestamp] = Optional.Absent,
    expirationDate: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse = {
    import GenerateClientCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse
      .builder()
      .optionallyWith(
        clientCertificateId.map(value => value: java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        pemEncodedCertificate.map(value => value: java.lang.String)
      )(_.pemEncodedCertificate)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly =
    zio.aws.apigateway.model.GenerateClientCertificateResponse
      .wrap(buildAwsValue())
}
object GenerateClientCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GenerateClientCertificateResponse =
      zio.aws.apigateway.model.GenerateClientCertificateResponse(
        clientCertificateId.map(value => value),
        description.map(value => value),
        pemEncodedCertificate.map(value => value),
        createdDate.map(value => value),
        expirationDate.map(value => value),
        tags.map(value => value)
      )
    def clientCertificateId: Optional[String]
    def description: Optional[String]
    def pemEncodedCertificate: Optional[String]
    def createdDate: Optional[Timestamp]
    def expirationDate: Optional[Timestamp]
    def tags: Optional[Map[String, String]]
    def getClientCertificateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPemEncodedCertificate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pemEncodedCertificate", pemEncodedCertificate)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse
  ) extends zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly {
    override val clientCertificateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientCertificateId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val pemEncodedCertificate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pemEncodedCertificate())
      .map(value => value: String)
    override val createdDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse
  ): zio.aws.apigateway.model.GenerateClientCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
