package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class TestInvokeMethodResponse(
    status: Optional[Integer] = Optional.Absent,
    body: Optional[String] = Optional.Absent,
    headers: Optional[Map[String, String]] = Optional.Absent,
    multiValueHeaders: Optional[Map[String, Iterable[String]]] =
      Optional.Absent,
    log: Optional[String] = Optional.Absent,
    latency: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse = {
    import TestInvokeMethodResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.Integer))(_.status)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        headers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.headers)
      .optionallyWith(
        multiValueHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.multiValueHeaders)
      .optionallyWith(log.map(value => value: java.lang.String))(_.log)
      .optionallyWith(latency.map(value => value: java.lang.Long))(_.latency)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly =
    zio.aws.apigateway.model.TestInvokeMethodResponse.wrap(buildAwsValue())
}
object TestInvokeMethodResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TestInvokeMethodResponse =
      zio.aws.apigateway.model.TestInvokeMethodResponse(
        status.map(value => value),
        body.map(value => value),
        headers.map(value => value),
        multiValueHeaders.map(value => value),
        log.map(value => value),
        latency.map(value => value)
      )
    def status: Optional[Integer]
    def body: Optional[String]
    def headers: Optional[Map[String, String]]
    def multiValueHeaders: Optional[Map[String, List[String]]]
    def log: Optional[String]
    def latency: Optional[Long]
    def getStatus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("status", status)
    def getBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("body", body)
    def getHeaders: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("headers", headers)
    def getMultiValueHeaders: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("multiValueHeaders", multiValueHeaders)
    def getLog: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("log", log)
    def getLatency: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("latency", latency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
  ) extends zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly {
    override val status: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: Integer)
    override val body: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: String)
    override val headers: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.headers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val multiValueHeaders: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiValueHeaders())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val log: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.log())
      .map(value => value: String)
    override val latency: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.latency())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
  ): zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly = new Wrapper(
    impl
  )
}
