package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetClientCertificatesRequest(
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest = {
    import GetClientCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetClientCertificatesRequest.ReadOnly =
    zio.aws.apigateway.model.GetClientCertificatesRequest.wrap(buildAwsValue())
}
object GetClientCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetClientCertificatesRequest =
      zio.aws.apigateway.model.GetClientCertificatesRequest(
        position.map(value => value),
        limit.map(value => value)
      )
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest
  ) extends zio.aws.apigateway.model.GetClientCertificatesRequest.ReadOnly {
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest
  ): zio.aws.apigateway.model.GetClientCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
