package zio.aws.apigateway.model
import scala.jdk.CollectionConverters._
sealed trait EndpointType {
  def unwrap: software.amazon.awssdk.services.apigateway.model.EndpointType
}
object EndpointType {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.EndpointType
  ): zio.aws.apigateway.model.EndpointType = value match {
    case software.amazon.awssdk.services.apigateway.model.EndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.EndpointType.REGIONAL =>
      val r = REGIONAL
      r
    case software.amazon.awssdk.services.apigateway.model.EndpointType.EDGE =>
      val r = EDGE
      r
    case software.amazon.awssdk.services.apigateway.model.EndpointType.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.EndpointType =
      software.amazon.awssdk.services.apigateway.model.EndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object REGIONAL extends zio.aws.apigateway.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.EndpointType =
      software.amazon.awssdk.services.apigateway.model.EndpointType.REGIONAL
  }
  case object EDGE extends zio.aws.apigateway.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.EndpointType =
      software.amazon.awssdk.services.apigateway.model.EndpointType.EDGE
  }
  case object PRIVATE extends zio.aws.apigateway.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.EndpointType =
      software.amazon.awssdk.services.apigateway.model.EndpointType.PRIVATE
  }
}
