package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateRestApiRequest(
    name: String,
    description: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    cloneFrom: Optional[String] = Optional.Absent,
    binaryMediaTypes: Optional[Iterable[String]] = Optional.Absent,
    minimumCompressionSize: Optional[NullableInteger] = Optional.Absent,
    apiKeySource: Optional[zio.aws.apigateway.model.ApiKeySourceType] =
      Optional.Absent,
    endpointConfiguration: Optional[
      zio.aws.apigateway.model.EndpointConfiguration
    ] = Optional.Absent,
    policy: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    disableExecuteApiEndpoint: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest = {
    import CreateRestApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(cloneFrom.map(value => value: java.lang.String))(
        _.cloneFrom
      )
      .optionallyWith(
        binaryMediaTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.binaryMediaTypes)
      .optionallyWith(minimumCompressionSize.map(value => value: Integer))(
        _.minimumCompressionSize
      )
      .optionallyWith(apiKeySource.map(value => value.unwrap))(_.apiKeySource)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        disableExecuteApiEndpoint.map(value => value: java.lang.Boolean)
      )(_.disableExecuteApiEndpoint)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateRestApiRequest.ReadOnly =
    zio.aws.apigateway.model.CreateRestApiRequest.wrap(buildAwsValue())
}
object CreateRestApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateRestApiRequest =
      zio.aws.apigateway.model.CreateRestApiRequest(
        name,
        description.map(value => value),
        version.map(value => value),
        cloneFrom.map(value => value),
        binaryMediaTypes.map(value => value),
        minimumCompressionSize.map(value => value),
        apiKeySource.map(value => value),
        endpointConfiguration.map(value => value.asEditable),
        policy.map(value => value),
        tags.map(value => value),
        disableExecuteApiEndpoint.map(value => value)
      )
    def name: String
    def description: Optional[String]
    def version: Optional[String]
    def cloneFrom: Optional[String]
    def binaryMediaTypes: Optional[List[String]]
    def minimumCompressionSize: Optional[NullableInteger]
    def apiKeySource: Optional[zio.aws.apigateway.model.ApiKeySourceType]
    def endpointConfiguration
        : Optional[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly]
    def policy: Optional[String]
    def tags: Optional[Map[String, String]]
    def disableExecuteApiEndpoint: Optional[Boolean]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getCloneFrom: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloneFrom", cloneFrom)
    def getBinaryMediaTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("binaryMediaTypes", binaryMediaTypes)
    def getMinimumCompressionSize: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "minimumCompressionSize",
        minimumCompressionSize
      )
    def getApiKeySource
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ApiKeySourceType] =
      AwsError.unwrapOptionField("apiKeySource", apiKeySource)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.EndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDisableExecuteApiEndpoint: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableExecuteApiEndpoint", disableExecuteApiEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
  ) extends zio.aws.apigateway.model.CreateRestApiRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val cloneFrom: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cloneFrom())
      .map(value => value: String)
    override val binaryMediaTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.binaryMediaTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val minimumCompressionSize: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumCompressionSize())
        .map(value => value: NullableInteger)
    override val apiKeySource
        : Optional[zio.aws.apigateway.model.ApiKeySourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeySource())
        .map(value => zio.aws.apigateway.model.ApiKeySourceType.wrap(value))
    override val endpointConfiguration
        : Optional[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointConfiguration())
        .map(value =>
          zio.aws.apigateway.model.EndpointConfiguration.wrap(value)
        )
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val disableExecuteApiEndpoint: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableExecuteApiEndpoint())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
  ): zio.aws.apigateway.model.CreateRestApiRequest.ReadOnly = new Wrapper(impl)
}
