package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDocumentationVersionRequest(
    restApiId: String,
    documentationVersion: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest = {
    import UpdateDocumentationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .documentationVersion(documentationVersion: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateDocumentationVersionRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateDocumentationVersionRequest
      .wrap(buildAwsValue())
}
object UpdateDocumentationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateDocumentationVersionRequest =
      zio.aws.apigateway.model.UpdateDocumentationVersionRequest(
        restApiId,
        documentationVersion,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def documentationVersion: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDocumentationVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(documentationVersion)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest
  ) extends zio.aws.apigateway.model.UpdateDocumentationVersionRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val documentationVersion: String =
      impl.documentationVersion(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest
  ): zio.aws.apigateway.model.UpdateDocumentationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
