package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class PutIntegrationResponse(
    `type`: Optional[zio.aws.apigateway.model.IntegrationType] =
      Optional.Absent,
    httpMethod: Optional[String] = Optional.Absent,
    uri: Optional[String] = Optional.Absent,
    connectionType: Optional[zio.aws.apigateway.model.ConnectionType] =
      Optional.Absent,
    connectionId: Optional[String] = Optional.Absent,
    credentials: Optional[String] = Optional.Absent,
    requestParameters: Optional[Map[String, String]] = Optional.Absent,
    requestTemplates: Optional[Map[String, String]] = Optional.Absent,
    passthroughBehavior: Optional[String] = Optional.Absent,
    contentHandling: Optional[
      zio.aws.apigateway.model.ContentHandlingStrategy
    ] = Optional.Absent,
    timeoutInMillis: Optional[Integer] = Optional.Absent,
    cacheNamespace: Optional[String] = Optional.Absent,
    cacheKeyParameters: Optional[Iterable[String]] = Optional.Absent,
    integrationResponses: Optional[
      Map[String, zio.aws.apigateway.model.IntegrationResponse]
    ] = Optional.Absent,
    tlsConfig: Optional[zio.aws.apigateway.model.TlsConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse = {
    import PutIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(httpMethod.map(value => value: java.lang.String))(
        _.httpMethod
      )
      .optionallyWith(uri.map(value => value: java.lang.String))(_.uri)
      .optionallyWith(connectionType.map(value => value.unwrap))(
        _.connectionType
      )
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(credentials.map(value => value: java.lang.String))(
        _.credentials
      )
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(
        requestTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestTemplates)
      .optionallyWith(
        passthroughBehavior.map(value => value: java.lang.String)
      )(_.passthroughBehavior)
      .optionallyWith(contentHandling.map(value => value.unwrap))(
        _.contentHandling
      )
      .optionallyWith(timeoutInMillis.map(value => value: java.lang.Integer))(
        _.timeoutInMillis
      )
      .optionallyWith(cacheNamespace.map(value => value: java.lang.String))(
        _.cacheNamespace
      )
      .optionallyWith(
        cacheKeyParameters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheKeyParameters)
      .optionallyWith(
        integrationResponses.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.integrationResponses)
      .optionallyWith(tlsConfig.map(value => value.buildAwsValue()))(
        _.tlsConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly =
    zio.aws.apigateway.model.PutIntegrationResponse.wrap(buildAwsValue())
}
object PutIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutIntegrationResponse =
      zio.aws.apigateway.model.PutIntegrationResponse(
        `type`.map(value => value),
        httpMethod.map(value => value),
        uri.map(value => value),
        connectionType.map(value => value),
        connectionId.map(value => value),
        credentials.map(value => value),
        requestParameters.map(value => value),
        requestTemplates.map(value => value),
        passthroughBehavior.map(value => value),
        contentHandling.map(value => value),
        timeoutInMillis.map(value => value),
        cacheNamespace.map(value => value),
        cacheKeyParameters.map(value => value),
        integrationResponses.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        tlsConfig.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.apigateway.model.IntegrationType]
    def httpMethod: Optional[String]
    def uri: Optional[String]
    def connectionType: Optional[zio.aws.apigateway.model.ConnectionType]
    def connectionId: Optional[String]
    def credentials: Optional[String]
    def requestParameters: Optional[Map[String, String]]
    def requestTemplates: Optional[Map[String, String]]
    def passthroughBehavior: Optional[String]
    def contentHandling
        : Optional[zio.aws.apigateway.model.ContentHandlingStrategy]
    def timeoutInMillis: Optional[Integer]
    def cacheNamespace: Optional[String]
    def cacheKeyParameters: Optional[List[String]]
    def integrationResponses: Optional[
      Map[String, zio.aws.apigateway.model.IntegrationResponse.ReadOnly]
    ]
    def tlsConfig: Optional[zio.aws.apigateway.model.TlsConfig.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.apigateway.model.IntegrationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getHttpMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uri", uri)
    def getConnectionType
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ConnectionType] =
      AwsError.unwrapOptionField("connectionType", connectionType)
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getCredentials: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getRequestParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestTemplates", requestTemplates)
    def getPassthroughBehavior: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("passthroughBehavior", passthroughBehavior)
    def getContentHandling
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ContentHandlingStrategy] =
      AwsError.unwrapOptionField("contentHandling", contentHandling)
    def getTimeoutInMillis: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeoutInMillis", timeoutInMillis)
    def getCacheNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNamespace", cacheNamespace)
    def getCacheKeyParameters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheKeyParameters", cacheKeyParameters)
    def getIntegrationResponses: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.IntegrationResponse.ReadOnly
    ]] =
      AwsError.unwrapOptionField("integrationResponses", integrationResponses)
    def getTlsConfig
        : ZIO[Any, AwsError, zio.aws.apigateway.model.TlsConfig.ReadOnly] =
      AwsError.unwrapOptionField("tlsConfig", tlsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse
  ) extends zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly {
    override val `type`: Optional[zio.aws.apigateway.model.IntegrationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.apigateway.model.IntegrationType.wrap(value))
    override val httpMethod: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.httpMethod())
      .map(value => value: String)
    override val uri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => value: String)
    override val connectionType
        : Optional[zio.aws.apigateway.model.ConnectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionType())
        .map(value => zio.aws.apigateway.model.ConnectionType.wrap(value))
    override val connectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => value: String)
    override val credentials: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.credentials())
      .map(value => value: String)
    override val requestParameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val requestTemplates: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestTemplates())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val passthroughBehavior: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.passthroughBehavior())
      .map(value => value: String)
    override val contentHandling
        : Optional[zio.aws.apigateway.model.ContentHandlingStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentHandling())
        .map(value =>
          zio.aws.apigateway.model.ContentHandlingStrategy.wrap(value)
        )
    override val timeoutInMillis: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInMillis())
      .map(value => value: Integer)
    override val cacheNamespace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNamespace())
      .map(value => value: String)
    override val cacheKeyParameters: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheKeyParameters())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val integrationResponses: Optional[
      Map[String, zio.aws.apigateway.model.IntegrationResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationResponses())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.apigateway.model.IntegrationResponse
              .wrap(value)
          })
          .toMap
      )
    override val tlsConfig
        : Optional[zio.aws.apigateway.model.TlsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsConfig())
        .map(value => zio.aws.apigateway.model.TlsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse
  ): zio.aws.apigateway.model.PutIntegrationResponse.ReadOnly = new Wrapper(
    impl
  )
}
