package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVpcLinkResponse(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    targetArns: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[zio.aws.apigateway.model.VpcLinkStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse = {
    import GetVpcLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        targetArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetArns)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly =
    zio.aws.apigateway.model.GetVpcLinkResponse.wrap(buildAwsValue())
}
object GetVpcLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetVpcLinkResponse =
      zio.aws.apigateway.model.GetVpcLinkResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        targetArns.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def targetArns: Optional[List[String]]
    def status: Optional[zio.aws.apigateway.model.VpcLinkStatus]
    def statusMessage: Optional[String]
    def tags: Optional[Map[String, String]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTargetArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetArns", targetArns)
    def getStatus: ZIO[Any, AwsError, zio.aws.apigateway.model.VpcLinkStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse
  ) extends zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val targetArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Optional[zio.aws.apigateway.model.VpcLinkStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.apigateway.model.VpcLinkStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse
  ): zio.aws.apigateway.model.GetVpcLinkResponse.ReadOnly = new Wrapper(impl)
}
