package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentationPart(
    id: Optional[String] = Optional.Absent,
    location: Optional[zio.aws.apigateway.model.DocumentationPartLocation] =
      Optional.Absent,
    properties: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DocumentationPart = {
    import DocumentationPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DocumentationPart
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(properties.map(value => value: java.lang.String))(
        _.properties
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DocumentationPart.ReadOnly =
    zio.aws.apigateway.model.DocumentationPart.wrap(buildAwsValue())
}
object DocumentationPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DocumentationPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DocumentationPart =
      zio.aws.apigateway.model.DocumentationPart(
        id.map(value => value),
        location.map(value => value.asEditable),
        properties.map(value => value)
      )
    def id: Optional[String]
    def location
        : Optional[zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly]
    def properties: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getProperties: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DocumentationPart
  ) extends zio.aws.apigateway.model.DocumentationPart.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val location: Optional[
      zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.apigateway.model.DocumentationPartLocation.wrap(value)
      )
    override val properties: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DocumentationPart
  ): zio.aws.apigateway.model.DocumentationPart.ReadOnly = new Wrapper(impl)
}
