package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateRequestValidatorRequest(
    restApiId: String,
    requestValidatorId: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest = {
    import UpdateRequestValidatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .requestValidatorId(requestValidatorId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateRequestValidatorRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateRequestValidatorRequest.wrap(buildAwsValue())
}
object UpdateRequestValidatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateRequestValidatorRequest =
      zio.aws.apigateway.model.UpdateRequestValidatorRequest(
        restApiId,
        requestValidatorId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def requestValidatorId: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getRequestValidatorId: ZIO[Any, Nothing, String] =
      ZIO.succeed(requestValidatorId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest
  ) extends zio.aws.apigateway.model.UpdateRequestValidatorRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val requestValidatorId: String = impl.requestValidatorId(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest
  ): zio.aws.apigateway.model.UpdateRequestValidatorRequest.ReadOnly =
    new Wrapper(impl)
}
