package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResourceResponse(
    id: Optional[String] = Optional.Absent,
    parentId: Optional[String] = Optional.Absent,
    pathPart: Optional[String] = Optional.Absent,
    path: Optional[String] = Optional.Absent,
    resourceMethods: Optional[Map[String, zio.aws.apigateway.model.Method]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse = {
    import UpdateResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(parentId.map(value => value: java.lang.String))(
        _.parentId
      )
      .optionallyWith(pathPart.map(value => value: java.lang.String))(
        _.pathPart
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(
        resourceMethods.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.resourceMethods)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateResourceResponse.wrap(buildAwsValue())
}
object UpdateResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateResourceResponse =
      zio.aws.apigateway.model.UpdateResourceResponse(
        id.map(value => value),
        parentId.map(value => value),
        pathPart.map(value => value),
        path.map(value => value),
        resourceMethods.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def id: Optional[String]
    def parentId: Optional[String]
    def pathPart: Optional[String]
    def path: Optional[String]
    def resourceMethods
        : Optional[Map[String, zio.aws.apigateway.model.Method.ReadOnly]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getParentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getPathPart: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pathPart", pathPart)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getResourceMethods: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.Method.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceMethods", resourceMethods)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse
  ) extends zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val parentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parentId())
      .map(value => value: String)
    override val pathPart: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pathPart())
      .map(value => value: String)
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val resourceMethods
        : Optional[Map[String, zio.aws.apigateway.model.Method.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceMethods())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.apigateway.model.Method.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse
  ): zio.aws.apigateway.model.UpdateResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
