package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetAuthorizersRequest(
    restApiId: String,
    position: Optional[String] = Optional.Absent,
    limit: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest = {
    import GetAuthorizersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetAuthorizersRequest.ReadOnly =
    zio.aws.apigateway.model.GetAuthorizersRequest.wrap(buildAwsValue())
}
object GetAuthorizersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetAuthorizersRequest =
      zio.aws.apigateway.model.GetAuthorizersRequest(
        restApiId,
        position.map(value => value),
        limit.map(value => value)
      )
    def restApiId: String
    def position: Optional[String]
    def limit: Optional[NullableInteger]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
  ) extends zio.aws.apigateway.model.GetAuthorizersRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val limit: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest
  ): zio.aws.apigateway.model.GetAuthorizersRequest.ReadOnly = new Wrapper(impl)
}
