package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.DocumentationPartLocationStatusCode
import scala.jdk.CollectionConverters._
final case class DocumentationPartLocation(
    `type`: zio.aws.apigateway.model.DocumentationPartType,
    path: Optional[String] = Optional.Absent,
    method: Optional[String] = Optional.Absent,
    statusCode: Optional[DocumentationPartLocationStatusCode] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DocumentationPartLocation = {
    import DocumentationPartLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DocumentationPartLocation
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(method.map(value => value: java.lang.String))(_.method)
      .optionallyWith(
        statusCode.map(value =>
          DocumentationPartLocationStatusCode.unwrap(value): java.lang.String
        )
      )(_.statusCode)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly =
    zio.aws.apigateway.model.DocumentationPartLocation.wrap(buildAwsValue())
}
object DocumentationPartLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DocumentationPartLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DocumentationPartLocation =
      zio.aws.apigateway.model.DocumentationPartLocation(
        `type`,
        path.map(value => value),
        method.map(value => value),
        statusCode.map(value => value),
        name.map(value => value)
      )
    def `type`: zio.aws.apigateway.model.DocumentationPartType
    def path: Optional[String]
    def method: Optional[String]
    def statusCode: Optional[DocumentationPartLocationStatusCode]
    def name: Optional[String]
    def getType
        : ZIO[Any, Nothing, zio.aws.apigateway.model.DocumentationPartType] =
      ZIO.succeed(`type`)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("method", method)
    def getStatusCode: ZIO[Any, AwsError, DocumentationPartLocationStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DocumentationPartLocation
  ) extends zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly {
    override val `type`: zio.aws.apigateway.model.DocumentationPartType =
      zio.aws.apigateway.model.DocumentationPartType.wrap(impl.`type`())
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val method: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.method())
      .map(value => value: String)
    override val statusCode: Optional[DocumentationPartLocationStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.apigateway.model.primitives
            .DocumentationPartLocationStatusCode(value)
        )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DocumentationPartLocation
  ): zio.aws.apigateway.model.DocumentationPartLocation.ReadOnly = new Wrapper(
    impl
  )
}
