package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDomainNameRequest(domainName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest = {
    import DeleteDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteDomainNameRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteDomainNameRequest.wrap(buildAwsValue())
}
object DeleteDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteDomainNameRequest =
      zio.aws.apigateway.model.DeleteDomainNameRequest(domainName)
    def domainName: String
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest
  ) extends zio.aws.apigateway.model.DeleteDomainNameRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest
  ): zio.aws.apigateway.model.DeleteDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
