package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class GetTagsRequest(
    resourceArn: String,
    position: Option[String] = None,
    limit: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetTagsRequest = {
    import GetTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetTagsRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetTagsRequest.ReadOnly =
    zio.aws.apigateway.model.GetTagsRequest.wrap(buildAwsValue())
}
object GetTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetTagsRequest =
      zio.aws.apigateway.model.GetTagsRequest(
        resourceArn,
        position.map(value => value),
        limit.map(value => value)
      )
    def resourceArn: String
    def position: Option[String]
    def limit: Option[NullableInteger]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetTagsRequest
  ) extends zio.aws.apigateway.model.GetTagsRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] =
      scala.Option(impl.limit()).map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetTagsRequest
  ): zio.aws.apigateway.model.GetTagsRequest.ReadOnly = new Wrapper(impl)
}
