package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MethodSnapshot(
    authorizationType: Option[String] = None,
    apiKeyRequired: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.MethodSnapshot = {
    import MethodSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.MethodSnapshot
      .builder()
      .optionallyWith(authorizationType.map(value => value: java.lang.String))(
        _.authorizationType
      )
      .optionallyWith(apiKeyRequired.map(value => value: java.lang.Boolean))(
        _.apiKeyRequired
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.MethodSnapshot.ReadOnly =
    zio.aws.apigateway.model.MethodSnapshot.wrap(buildAwsValue())
}
object MethodSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.MethodSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.MethodSnapshot =
      zio.aws.apigateway.model.MethodSnapshot(
        authorizationType.map(value => value),
        apiKeyRequired.map(value => value)
      )
    def authorizationType: Option[String]
    def apiKeyRequired: Option[Boolean]
    def getAuthorizationType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizationType", authorizationType)
    def getApiKeyRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("apiKeyRequired", apiKeyRequired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSnapshot
  ) extends zio.aws.apigateway.model.MethodSnapshot.ReadOnly {
    override val authorizationType: Option[String] =
      scala.Option(impl.authorizationType()).map(value => value: String)
    override val apiKeyRequired: Option[Boolean] =
      scala.Option(impl.apiKeyRequired()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.MethodSnapshot
  ): zio.aws.apigateway.model.MethodSnapshot.ReadOnly = new Wrapper(impl)
}
