package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.Blob
import scala.jdk.CollectionConverters._
final case class ImportApiKeysRequest(
    body: Blob,
    format: zio.aws.apigateway.model.ApiKeysFormat,
    failOnWarnings: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest = {
    import ImportApiKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest
      .builder()
      .body(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(body.toArray[Byte])
      )
      .format(format.unwrap)
      .optionallyWith(failOnWarnings.map(value => value: java.lang.Boolean))(
        _.failOnWarnings
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.ImportApiKeysRequest.ReadOnly =
    zio.aws.apigateway.model.ImportApiKeysRequest.wrap(buildAwsValue())
}
object ImportApiKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ImportApiKeysRequest =
      zio.aws.apigateway.model
        .ImportApiKeysRequest(body, format, failOnWarnings.map(value => value))
    def body: Blob
    def format: zio.aws.apigateway.model.ApiKeysFormat
    def failOnWarnings: Option[Boolean]
    def getBody: ZIO[Any, Nothing, Blob] = ZIO.succeed(body)
    def getFormat: ZIO[Any, Nothing, zio.aws.apigateway.model.ApiKeysFormat] =
      ZIO.succeed(format)
    def getFailOnWarnings: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("failOnWarnings", failOnWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest
  ) extends zio.aws.apigateway.model.ImportApiKeysRequest.ReadOnly {
    override val body: Blob = zio.aws.apigateway.model.primitives
      .Blob(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
    override val format: zio.aws.apigateway.model.ApiKeysFormat =
      zio.aws.apigateway.model.ApiKeysFormat.wrap(impl.format())
    override val failOnWarnings: Option[Boolean] =
      scala.Option(impl.failOnWarnings()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest
  ): zio.aws.apigateway.model.ImportApiKeysRequest.ReadOnly = new Wrapper(impl)
}
