package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcLink(
    id: Option[String] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    targetArns: Option[Iterable[String]] = None,
    status: Option[zio.aws.apigateway.model.VpcLinkStatus] = None,
    statusMessage: Option[String] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.VpcLink = {
    import VpcLink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.VpcLink
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        targetArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetArns)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.VpcLink.ReadOnly =
    zio.aws.apigateway.model.VpcLink.wrap(buildAwsValue())
}
object VpcLink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.VpcLink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.VpcLink =
      zio.aws.apigateway.model.VpcLink(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        targetArns.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value => value)
      )
    def id: Option[String]
    def name: Option[String]
    def description: Option[String]
    def targetArns: Option[List[String]]
    def status: Option[zio.aws.apigateway.model.VpcLinkStatus]
    def statusMessage: Option[String]
    def tags: Option[Map[String, String]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTargetArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetArns", targetArns)
    def getStatus: ZIO[Any, AwsError, zio.aws.apigateway.model.VpcLinkStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.VpcLink
  ) extends zio.aws.apigateway.model.VpcLink.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val targetArns: Option[List[String]] = scala
      .Option(impl.targetArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Option[zio.aws.apigateway.model.VpcLinkStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.apigateway.model.VpcLinkStatus.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.VpcLink
  ): zio.aws.apigateway.model.VpcLink.ReadOnly = new Wrapper(impl)
}
